package com.ejie.ab04b.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.TipoCambio;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.CoordinadorObra;
import com.ejie.ab04b.model.DocumentoAperturas;
import com.ejie.ab04b.model.HistCambiosAperturas;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;

/**
 * 
 * @author GFI-NORTE
 * 
 */
public class HistCambiosAperturasUtil {

	private static HistCambiosAperturasUtil instance;
	private ReloadableResourceBundleMessageSource appMessageSource;

	private static final Logger logger = LoggerFactory
			.getLogger(HistCambiosAperturasUtil.class);

	/**
	 * Devuelve la instancia de tipo Utilities.
	 * 
	 * @return Devuelve la instancia de tipo Utilities
	 */
	public static final HistCambiosAperturasUtil getInstance() {
		if (HistCambiosAperturasUtil.instance == null) {
			HistCambiosAperturasUtil.instance = new HistCambiosAperturasUtil();
		}
		return HistCambiosAperturasUtil.instance;
	}

	/**
	 * Cargar diferencias historico.
	 * 
	 * @param historico
	 *            HistCambiosAperturas
	 * @param original
	 *            StringBuffer
	 * @param modif
	 *            StringBuffer
	 * @param tipoCambio
	 *            String
	 * @param idioma
	 *            String
	 * @param appMessageSource
	 *            ReloadableResourceBundleMessageSource
	 */
	public void cargarDiferenciasHistorico(HistCambiosAperturas historico,
			StringBuffer original, StringBuffer modif, String tipoCambio,
			String idioma,
			ReloadableResourceBundleMessageSource appMessageSource) {

		this.appMessageSource = appMessageSource;
		String apeModif = historico.getRegmidificaciones087();
		String apeOriginal = historico.getRegoriginal087();

		Locale locale = new Locale(idioma);

		// empezamos a recorrer por etiquetas
		// cambio de coordinador

		if (historico.getTipocambio087().equalsIgnoreCase(
				TipoCambio.COORD_EJEC_OBRA.getCodigo())) {
			original.append("<ul class='listaCambiosUl'>");
			modif.append("<ul class='listaCambiosUl'>");
			this.comparador(apeOriginal, apeModif, "tipoCoordinador", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "numeroDocumento", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "tipoDocumento", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaBaja", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaAlta", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "nombreCoordinador",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "descripcionMunicipio",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "direccion", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "codigoPostal", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "titulacion", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "telefono", original, modif,
					locale);
			this.comparador(apeOriginal, apeModif, "territorioExpediente",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "anioExpediente", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "numeroExpediente",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "ordenExpediente", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "usuarioAlta", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaModificacion",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "usuarioModificacion",
					original, modif, locale);
			try {
				this.comparadorFCA(apeOriginal, apeModif, "descripcionFCA",
						original, modif, locale, idioma);
			} catch (Exception e) {
				HistCambiosAperturasUtil.logger.error(
						"ERROR en cargarDiferenciasHistorico", e);
			}
			original.append("</ul>");
			modif.append("</ul>");

		} else if (historico.getTipocambio087().equalsIgnoreCase(
				TipoCambio.MODIFICACION_APERTURA.getCodigo())
				|| historico.getTipocambio087().equalsIgnoreCase(
						TipoCambio.SUBSANACION_APERTURA.getCodigo())) {

			if (historico.getRegoriginal087().indexOf("pestana") >= 0) {
				// modificarApertura
				this.comparador(apeOriginal, apeModif, "pestana", original,
						modif, locale);
			} else {
				original.append("<ul class='listaCambiosUl'>");
				modif.append("<ul class='listaCambiosUl'>");
			}

			// modificarApertura
			this.comparador(apeOriginal, apeModif, "territorioAvP056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "anoAvP056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaPresentacion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaCierre056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "empresaNueva056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "tipoDoc056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "numeroDoc056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "nombreEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "descripcionMunEmp056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "direccionEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "codigoPostalEmp056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "telefonoEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "cnaeEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "tipoApe056", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "municipioEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "provinciaEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "paisEmp056", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "municipioCnTrb056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "provinciaCnTrb056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "territorioCnTrb056",
					original, modif, locale);

			this.comparador(apeOriginal, apeModif, "localidadCnTrb056",
					original, modif, locale);

			this.comparador(apeOriginal, apeModif, "entidadEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "nombreCnTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "direccionCnTrb056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "codigoPostalCnTrb056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "telefonoCnTrb056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "faxCnTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "emailCnTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "cnaeCnTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "provinciaSgSc056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "numeroSgSc056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "digControlSgSc056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaInicio056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "trbHombres056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "trbMujeres056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "trbTotal056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "claseCnTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "descripcionObra056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "superficie056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "planSg056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "canalPlan056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "planPresentacion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "proyectoTecnico056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "descMaquinaria056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "potencia056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "indAnexo056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "apdoAnexo056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "descTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "indicadorObra056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "territorioAvP056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "anoAvP056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "numeroAvP056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "loteMnt056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "visOsalan056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "asgOsalan056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "tecOsalan056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaVisitaOsalan056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "visInspeccion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "asgInspeccion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "tecInspeccion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaVisitaInspeccion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaEnvio056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaReq056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaSub056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaInfOsl056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaInfInsp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaAlta056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "usuarioAlta056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "usuarioModificacion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "descEmp056", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "dirobr082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "locobr082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "munobr082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "terexp082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "desobr082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "tipobr082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "durpre082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "durpreDesde082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "durpreHasta082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "unitmp082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "trbtot082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "trbmuj082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "trbhom082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "destrab082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "apdoanx2082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "indanx2082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "fecini082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "fecfin082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "descCnTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "documentacionCorrecta056",
					original, modif, locale);
			// this.comparador(apeOriginal, apeModif, "cnaeCnTrb056", original,
			// modif, locale);
			// this.comparador(apeOriginal, apeModif, "cnaeEmp056", original,
			// modif, locale);
			this.comparador(apeOriginal, apeModif, "modalidadPreventiva056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif,
					"numeroPrevistoConSubAut056", original, modif, locale);
			this.comparador(apeOriginal, apeModif, "acompanaEvalRiesgos056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "canalEvalRiesgos056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif,
					"inscripcionRegistroEmpresa056", original, modif, locale);
			this.comparador(apeOriginal, apeModif, "numeroDocRepresentante056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "tlfRepresentante056",
					original, modif, locale);

			this.comparador(apeOriginal, apeModif, "idiomanotif", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "canalnotif", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "prvnotif", original, modif,
					locale);
			this.comparador(apeOriginal, apeModif, "municnotif", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "locnotif", original, modif,
					locale);
			this.comparador(apeOriginal, apeModif, "cpnotif", original, modif,
					locale);
			this.comparador(apeOriginal, apeModif, "dirnotif", original, modif,
					locale);

			original.append("</ul>");
			modif.append("</ul>");

		} else if (historico.getTipocambio087().equalsIgnoreCase(
				TipoCambio.ELIMINACION_APERTURA.getCodigo())) {

			original.append("<ul class='listaCambiosUl'>");
			modif.append("<ul class='listaCambiosUl'>");

			this.comparador(apeOriginal, apeModif, "usuarioModificacion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaModificacion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "elementoEliminado056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "motivoEliminacion",
					original, modif, locale);

			original.append("</ul>");
			modif.append("</ul>");
		}

	}

	/**
	 * Comparador.
	 * 
	 * @param apeOriginal
	 *            String
	 * @param apeModif
	 *            String
	 * @param label
	 *            String
	 * @param original
	 *            String
	 * @param modif
	 *            String
	 * @param locale
	 *            Locale
	 */
	private void comparador(String apeOriginal, String apeModif, String label,
			StringBuffer original, StringBuffer modif, Locale locale) {
		/*
		 * if (M01BTratarFiltroHistorico.traza.isTraceActive()) {
		 * M01BTratarFiltroHistorico.traza.trace("M01B",Q70TraceLevel.DEBUG ,
		 * "M01BTratarFiltroHistorico comparador(...) "); }
		 */
		int posIni = 0;
		int posFinal = 0;
		String valorTempOrig = "";
		String valorTempModif = "";

		posIni = apeModif.indexOf(label);

		// calculamos la posicion, pero en vez desde la etiqueta, desde el igual
		posIni = apeModif.indexOf("=", posIni);
		if (posIni >= 0) {
			posFinal = apeModif.indexOf(";", posIni + 1);
			valorTempModif = apeModif.substring(posIni + 1, posFinal);
			posIni = apeOriginal.indexOf(label);
			posIni = apeOriginal.indexOf("=", posIni);
			posFinal = apeOriginal.indexOf(";", posIni + 1);
			valorTempOrig = apeOriginal.substring(posIni + 1, posFinal);
			if (valorTempOrig.equalsIgnoreCase("null")) {
				valorTempOrig = "";
			}
			if (valorTempModif.equalsIgnoreCase("null")) {
				// && !"".equals(valorTempOrig)) {
				valorTempModif = "";
			}
			if ("pestana".equals(label)) {

				String labelMostrar = this.appMessageSource.getMessage("label."
						+ label, null, locale)
						+ ": ";
				original.append("<ul class='listaCambiosUl'>")
						.append(labelMostrar)
						.append("<span class='datosResaltados'>")
						.append(valorTempOrig).append("</span>");
				modif.append("<ul class='listaCambiosUl'>")
						.append(labelMostrar)
						.append("<span class='datosResaltados'>")
						.append(valorTempOrig).append("</span>");
			}
			if (!valorTempOrig.equalsIgnoreCase(valorTempModif)
					&& !"".equals(valorTempModif)) {

				String labelMostrar = "<b>"
						+ this.appMessageSource.getMessage("label." + label,
								null, locale) + ": </b>";

				original.append("<li class='elementoListaCambio'>")
						.append(labelMostrar).append(valorTempOrig)
						.append("</li>");
				modif.append("<li class='elementoListaCambio'>")
						.append(labelMostrar).append(valorTempModif)
						.append("</li>");
			}
		}
	}

	/**
	 * Comparador FCA.
	 * 
	 * @param apeOriginal
	 *            String
	 * @param apeModif
	 *            String
	 * @param label
	 *            String
	 * @param original
	 *            String
	 * @param modif
	 *            String
	 * @param locale
	 *            String
	 * @param idioma
	 *            Locale
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	private void comparadorFCA(String apeOriginal, String apeModif,
			String label, StringBuffer original, StringBuffer modif,
			Locale locale, String idioma) throws AB04BException {
		try {
			int posIni = 0;
			int posFinal = 0;
			String valorTempOrig = "";
			String valorTempModif = "";

			posIni = apeModif.indexOf(label);

			// calculamos la posicion, pero en vez desde la etiqueta, desde el
			// igual
			posIni = apeModif.indexOf("=", posIni);
			if (posIni >= 0) {
				posFinal = apeModif.indexOf(";", posIni + 1);
				valorTempModif = apeModif.substring(posIni + 1, posFinal);
				posIni = apeOriginal.indexOf(label);
				posIni = apeOriginal.indexOf("=", posIni);
				posFinal = apeOriginal.indexOf(";", posIni + 1);
				valorTempOrig = apeOriginal.substring(posIni + 1, posFinal);
				if (valorTempOrig.equalsIgnoreCase("null")) {
					valorTempOrig = "";
				}
				if (valorTempModif.equalsIgnoreCase("null")) {
					valorTempModif = "";
				}
				if (!valorTempOrig.equalsIgnoreCase(valorTempModif)) {
					String labelMostrar = "<b>"
							+ this.appMessageSource.getMessage(
									"label." + label, null, locale) + ": </b>";
					original.append("<li class='elementoListaCambio'>")
							.append(labelMostrar)
							.append(this.parsearDesc(valorTempOrig, idioma))
							.append("</li>");
					modif.append("<li class='elementoListaCambio'>")
							.append(labelMostrar)
							.append(this.parsearDesc(valorTempModif, idioma))
							.append("</li>");
				}
			}
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * Parsear desc.
	 * 
	 * @param valor
	 *            String
	 * @param idioma
	 *            String
	 * @return String
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	private String parsearDesc(String valor, String idioma)
			throws AB04BException {
		try {

			FcasNameParser fcaparser = new FcasNameParser(valor);

			return fcaparser.getFcasDesc(idioma);
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

	/**
	 * Concatenar campos apertura.
	 * 
	 * @param pestana
	 *            String
	 * @param apertura
	 *            ComunicacionApertura
	 * @return String
	 */
	public static String concatenarCamposApertura(String pestana,
			ComunicacionApertura apertura) {
		String mascara = Utilities.getInstance().getDateMask();
		SimpleDateFormat sdf = new SimpleDateFormat(mascara);

		StringBuffer buffer = new StringBuffer();
		buffer.append("pestana=").append(pestana).append(";");
		buffer.append("usuarioModif=")
				.append(UtilSeguridad.getInstance().getNombre()).append(";");
		buffer.append("territorioAvP056=").append(apertura.getTerape056())
				.append(";").append("anoAvP056=")
				.append(apertura.getAnoape056()).append(";")
				.append("idApe056=").append(apertura.getIdape056()).append(";");
		if (apertura.getFecpre056() != null) {
			buffer.append("fechaPresentacion056=")
					.append(sdf.format(apertura.getFecpre056())).append(";");
		} else {
			buffer.append("fechaPresentacion056=").append(";");
		}
		if (apertura.getFecier056() != null) {
			buffer.append("fechaCierre056=")
					.append(sdf.format(apertura.getFecier056())).append(";");
		} else {
			buffer.append("fechaCierre056=").append(";");
		}
		// .append("fechaCierre056=").append(sdf.format(apertura.getFechaCierre056())).append(";")
		buffer.append("empresaNueva056=").append(apertura.getNueva056())
				.append(";").append("tipoDoc056=");
		buffer.append(apertura.getTipdoc056()).append(";")
				.append("numeroDoc056=").append(apertura.getNumdoc056())
				.append(";").append("nombreEmp056=")
				.append(apertura.getNomemp056()).append(";")
				.append("paisEmp056=").append(apertura.getPaisemp056())
				.append(";").append("provinciaEmp056=");
		if (apertura.getProvinciaEmp() != null) {
			buffer.append(apertura.getProvinciaEmp().getCodProvincia());
		}
		buffer.append(";").append("municipioEmp056=");
		if (apertura.getMunicipioEmp() != null) {
			buffer.append(apertura.getMunicipioEmp().getCodMunicipio());
		}

		buffer.append(";").append("descripcionMunEmp056=")
				.append(apertura.getDmunemp056()).append(";")
				.append("direccionEmp056=").append(apertura.getDiremp056())
				.append(";").append("codigoPostalEmp056=")
				.append(apertura.getCpoemp056()).append(";")
				.append("telefonoEmp056=").append(apertura.getTlfemp056())
				.append(";").append("cnaeEmp056=")
				.append(apertura.getCnaeemp056()).append(";")
				.append("entidadEmp056=").append(apertura.getEntiat056())
				.append(";").append("tipoApe056=");
		if (apertura.getTipoApertura() != null) {
			buffer.append(apertura.getTipoApertura().getTipape071());
		}
		buffer.append(";").append("nombreCnTrb056=")
				.append(apertura.getNomctr056()).append(";")
				.append("provinciaCnTrb056=");
		if (apertura.getProvinciaCtr() != null) {
			buffer.append(apertura.getProvinciaCtr().getCodProvincia());
		}
		buffer.append(";").append("municipioCnTrb056=");
		if (apertura.getMunicipioCtr() != null) {
			buffer.append(apertura.getMunicipioCtr().getCodMunicipio());
		}
		buffer.append(";").append("localidadCnTrb056=")
				.append(apertura.getLocctr056()).append(";")
				.append("direccionCnTrb056=").append(apertura.getDirctr056())
				.append(";").append("codigoPostalCnTrb056=")
				.append(apertura.getCpoctr056()).append(";")
				.append("telefonoCnTrb056=").append(apertura.getTlfctr056())
				.append(";").append("faxCnTrb056=")
				.append(apertura.getFaxctr056()).append(";")
				.append("emailCnTrb056=").append(apertura.getEmailctr056())
				.append(";").append("cnaeCnTrb056=")
				.append(apertura.getCnaectr056()).append(";")
				.append("provinciaSgSc056=").append(apertura.getPrvss056())
				.append(";").append("numeroSgSc056=")
				.append(apertura.getNumss056()).append(";")
				.append("digControlSgSc056=").append(apertura.getDigss056())
				.append(";");
		if (apertura.getFecini056() != null) {
			buffer.append("fechaInicio056=")
					.append(sdf.format(apertura.getFecini056())).append(";");
		} else {
			buffer.append("fechaInicio056=").append(";");
		}
		// .append("fechaInicio056=").append(apertura.getFechaInicio056()).append(";")
		buffer.append("trbHombres056=")
				.append(apertura.getTrbhom056())
				.append(";")
				.append("trbMujeres056=")
				.append(apertura.getTrbmuj056())
				.append(";")
				.append("trbTotal056=")
				.append(apertura.getTrbtot056())
				.append(";")
				.append("claseCnTrb056=")
				.append(apertura.getClasctr056())
				.append(";")
				.append("descripcionObra056=")
				.append(apertura.getDescobr056())
				.append(";")
				.append("superficie056=")
				.append(apertura.getSuperf056())
				.append(";")
				.append("planSg056=")
				.append(apertura.getPlanseg056())
				.append(";")
				.append("canalPlan056=")
				.append(apertura.getCanalplan056())
				.append(";")
				.append("planPresentacion056=")
				.append(apertura.getPlanpres056())
				.append(";")
				.append("proyectoTecnico056=")
				.append(apertura.getProytec056())
				.append(";")
				// modalidadPreventiva
				.append("descMaquinaria056=").append(apertura.getDescmaq056())
				.append(";").append("potencia056=")
				.append(apertura.getPoten056()).append(";")
				.append("indAnexo056=").append(apertura.getIndanx056())
				.append(";").append("apdoAnexo056=")
				.append(apertura.getApdoanx056()).append(";")
				.append("descTrb056=").append(apertura.getDestrab056())
				.append(";").append("indicadorObra056=")
				.append(apertura.getIndobra056()).append(";")
				.append("territorioAvP056=").append(apertura.getTerape056())
				.append(";").append("anoAvP056=")
				.append(apertura.getAnoape056()).append(";")
				.append("numeroAvP056=").append(apertura.getNumape056())
				.append(";").append("codigoObra056=")
				.append(apertura.getCodobra056()).append(";")
				.append("codigoCnTrb056=").append(apertura.getCodctr056())
				.append(";").append("loteMnt056=")
				.append(apertura.getLotemnt056()).append(";")
				.append("visOsalan056=").append(apertura.getVisosl056())
				.append(";").append("asgOsalan056=")
				.append(apertura.getAsgosl056()).append(";")
				.append("tecOsalan056=").append(apertura.getTecosl056())
				.append(";");

		if (apertura.getFvisosl056() != null) {
			buffer.append("fechaVisitaOsalan056=")
					.append(sdf.format(apertura.getFvisosl056())).append(";");
		} else {
			buffer.append("fechaVisitaOsalan056=").append(";");
		}

		buffer.append("visInspeccion056=").append(apertura.getVisins056())
				.append(";").append("asgInspeccion056=")
				.append(apertura.getAsgins056()).append(";")
				.append("tecInspeccion056=").append(apertura.getTecins056())
				.append(";");

		if (apertura.getFvisins056() != null) {
			buffer.append("fechaVisitaInspeccion056=")
					.append(sdf.format(apertura.getFvisins056())).append(";");
		} else {
			buffer.append("fechaVisitaInspeccion056=").append(";");
		}

		// .append("fechaVisitaInspeccion056=").append(sdf.format(apertura.getFechaVisitaInspeccion056())).append(";")

		if (apertura.getFecinsp056() != null) {
			buffer.append("fechaEnvio056=")
					.append(sdf.format(apertura.getFecinsp056())).append(";");
		} else {
			buffer.append("fechaEnvio056=").append(";");
		}
		// buffer.append("fechaEnvio056=").append(sdf.format(apertura.getFechaEnvio056())).append(";")

		if (apertura.getFecreq056() != null) {
			buffer.append("fechaReq056=")
					.append(sdf.format(apertura.getFecreq056())).append(";");
		} else {
			buffer.append("fechaReq056=").append(";");
		}

		// buffer.append("fechaReq056=").append(sdf.format(apertura.getFechaReq056())).append(";")

		if (apertura.getFecsub056() != null) {
			buffer.append("fechaSub056=")
					.append(sdf.format(apertura.getFecsub056())).append(";");
		} else {
			buffer.append("fechaSub056=").append(";");
		}
		// .append("fechaSub056=").append(sdf.format(apertura.getFechaSub056())).append(";")
		if (apertura.getFinfosl056() != null) {
			buffer.append("fechaInfOsl056=")
					.append(sdf.format(apertura.getFinfosl056())).append(";");
		} else {
			buffer.append("fechaInfOsl056=").append(";");
		}

		// .append("fechaInfOsl056=").append(sdf.format(apertura.getFechaInfOsl056())).append(";")
		if (apertura.getFinfinsp056() != null) {
			buffer.append("fechaInfInsp056=")
					.append(sdf.format(apertura.getFinfinsp056())).append(";");
		} else {
			buffer.append("fechaInfInsp056=").append(";");
		}

		// .append("fechaInfInsp056=").append(sdf.format(apertura.getFechaInfInsp056())).append(";")
		if (apertura.getFecalt056() != null) {
			buffer.append("fechaAlta056=")
					.append(sdf.format(apertura.getFecalt056())).append(";");
		} else {
			buffer.append("fechaAlta056=").append(";");
		}

		// .append("fechaAlta056=").append(sdf.format(apertura.getFechaAlta056())).append(";")
		buffer.append("usuarioAlta056=").append(apertura.getUsualt056())
				.append(";");

		if (apertura.getObra() != null && pestana.equals("Obra")) {
			buffer.append("dirobr082=")
					.append(apertura.getObra().getDirobr082()).append(";");

			buffer.append("locobr082=")
					.append(apertura.getObra().getLocobr082()).append(";");

			buffer.append("munobr082=")
					.append(apertura.getObra().getMunobr082()).append(";");

			buffer.append("terexp082=")
					.append(apertura.getObra().getTerexp082()).append(";");

			buffer.append("desobr082=")
					.append(apertura.getObra().getDesobr082()).append(";");

			buffer.append("tipobr082=")
					.append(apertura.getObra().getTipobr082()).append(";");

			buffer.append("durpre082=")
					.append(apertura.getObra().getDurpre082()).append(";");

			buffer.append("durpreDesde082=")
					.append(apertura.getObra().getDurpreDesde()).append(";");

			buffer.append("durpreHasta082=")
					.append(apertura.getObra().getDurpreHasta()).append(";");

			buffer.append("unitmp082=")
					.append(apertura.getObra().getUnitmp082()).append(";");

			buffer.append("trbtot082=")
					.append(apertura.getObra().getTrbtot082()).append(";");
			buffer.append("trbmuj082=")
					.append(apertura.getObra().getTrbmuj082()).append(";");
			buffer.append("trbhom082=")
					.append(apertura.getObra().getTrbhom082()).append(";");

			buffer.append("destrab082=")
					.append(apertura.getObra().getDestrab082()).append(";");

			if (apertura.getObra().getFecini082() != null) {
				buffer.append("fecini082=")
						.append(sdf.format(apertura.getObra().getFecini082()))
						.append(";");
			} else {
				buffer.append("fecini082=").append(";");
			}

			if (apertura.getObra().getFecfin082() != null) {
				buffer.append("fecfin082=")
						.append(sdf.format(apertura.getObra().getFecfin082()))
						.append(";");
			} else {
				buffer.append("fecfin082=").append(";");
			}

			buffer.append("apdoanx2082=")
					.append(apertura.getObra().getApdoanx2082()).append(";");
			buffer.append("indanx2082=")
					.append(apertura.getObra().getIndanx2082()).append(";");
		}
		if (apertura.getFecmod056() != null) {
			buffer.append("fechaModificacion056=")
					.append(sdf.format(apertura.getFecmod056())).append(";");
		} else {
			buffer.append("fechaModificacion056=").append(";");
		}
		// .append("fechaModificacion056=").append(sdf.format(apertura.getFechaModificacion056())).append(";")
		buffer.append("usuarioModificacion056=")
				.append(apertura.getUsumod056())
				.append(";")
				.append("descEmp056=")
				.append(";")
				.append("descCnTrb056=")
				.append(";")
				.append("documentacionCorrecta056=")
				.append(apertura.getDoccorrecta056())
				.append(";")
				.append("codentiat056=")
				.append(apertura.getCodentiat056())
				.append(";")
				// ESTADO_056
				.append("modalidadPreventiva056=")
				.append(apertura.getModpre056()).append(";")
				.append("numeroPrevistoConSubAut056=")
				.append(apertura.getNumcnt056()).append(";")
				.append("idApe056=").append(apertura.getIdape056()).append(";")
				.append("acompanaEvalRiesgos056=")
				.append(apertura.getEvalpres056()).append(";")
				.append("canalEvalRiesgos056=")
				.append(apertura.getCanaleval056()).append(";")
				.append("inscripcionRegistroEmpresa056=")
				.append(apertura.getRegemp056Completo()).append(";")
				.append("numeroDocRepresentante056=")
				.append(apertura.getNumdocrepresentante056()).append(";")
				.append("tlfRepresentante056=")
				.append(apertura.getTlfrepresentante056()).append(";");

		if (!Constantes.VALUE_SI.equals(apertura.getMigrado056())
				&& apertura.getDatosNotificacion() != null
				&& pestana.equals("Datos notificación.")) {
			buffer.append("idiomanotif=")
					.append(apertura.getDatosNotificacion().getIdioma066())
					.append(";");
			buffer.append("canalnotif=")
					.append(apertura.getDatosNotificacion().getCanalnotif066())
					.append(";");

			if (Constantes.CANAL_NOTIF_POSTAL.equals(apertura
					.getDatosNotificacion().getCanalnotif066())
					&& apertura.getDatosNotificacion().getDatosLocalizacion() != null) {
				buffer.append("prvnotif=")
						.append(apertura.getDatosNotificacion()
								.getDatosLocalizacion().getProvincia()
								.getDescripcion()).append(";");
				buffer.append("municnotif=")
						.append(apertura.getDatosNotificacion()
								.getDatosLocalizacion().getMunicipio()
								.getDescripcion()).append(";");
				buffer.append("locnotif=")
						.append((apertura.getDatosNotificacion()
								.getDatosLocalizacion().getLocalidad() != null) ? apertura
								.getDatosNotificacion().getDatosLocalizacion()
								.getLocalidad().getDescripcion()
								: "").append(";");
				buffer.append("cpnotif=")
						.append(apertura.getDatosNotificacion()
								.getDatosLocalizacion().getCodpostal067())
						.append(";");
				buffer.append("dirnotif=")
						.append(apertura.getDatosNotificacion()
								.getDatosLocalizacion().getDireccionCompleta())
						.append(";");

			}
		}
		return buffer.toString();
	}

	/**
	 * Concatenar campos.
	 * 
	 * @param coordinador
	 *            the coordinador
	 * @return the string
	 */
	public static String concatenarCampos(CoordinadorObra coordinador) {
		StringBuffer buffer = new StringBuffer();
		buffer.append("tipoCoordinador=E;");
		buffer.append("idApertura=").append(coordinador.getIdape084())
				.append(";");
		buffer.append("numeroDocumento=").append(coordinador.getNumdoc084())
				.append(";");
		buffer.append("tipoDocumento=").append(coordinador.getTipdoc084())
				.append(";");
		buffer.append("codigoObra=").append(coordinador.getCodobra084())
				.append(";");
		buffer.append("fechaBaja=").append(coordinador.getFecbaj084())
				.append(";");
		buffer.append("fechaAlta=").append(coordinador.getFecalt084())
				.append(";");
		buffer.append("nombreCoordinador=").append(coordinador.getNomcrd084())
				.append(";");
		buffer.append("pais=").append(coordinador.getPaiscrd084()).append(";");
		buffer.append("provincia=").append(coordinador.getPrvcrd084())
				.append(";");
		buffer.append("municipio=").append(coordinador.getMuncrd084())
				.append(";");

		buffer.append("descripcionMunicipio=")
				.append(coordinador.getDmuncrd084()).append(";");

		buffer.append("direccion=").append(coordinador.getDircrd084())
				.append(";");
		buffer.append("codigoPostal=").append(coordinador.getCpocrd084())
				.append(";");
		buffer.append("titulacion=").append(coordinador.getTitcrd084())
				.append(";");
		buffer.append("telefono=").append(coordinador.getTlfcrd084())
				.append(";");
		buffer.append("tipoApertura=2;");
		buffer.append("territorioExpediente=")
				.append(coordinador.getTerexp084()).append(";");
		buffer.append("anioExpediente=").append(coordinador.getAnoexp084())
				.append(";");
		buffer.append("numeroExpediente=").append(coordinador.getNumexp084())
				.append(";");
		buffer.append("ordenExpediente=").append(coordinador.getOrdexp084())
				.append(";");
		buffer.append("usuarioAlta=").append(coordinador.getUsualt084())
				.append(";");
		buffer.append("fechaModificacion=").append(coordinador.getFecmod084())
				.append(";");
		buffer.append("usuarioModificacion=")
				.append(coordinador.getUsumod084()).append(";");
		buffer.append("descripcionFCA=").append(coordinador.getDesccrd084())
				.append(";");

		return buffer.toString();
	}

	/**
	 * Concatenar campos.
	 * 
	 * @param listadoDocs
	 *            the listadoDocs
	 * @return the string
	 */
	public static String concatenarCamposDocumentos(
			ArrayList<DocumentoAperturas> listadoDocs) {
		StringBuffer buffer = new StringBuffer();
		buffer.append("pestana=Documentos;");
		buffer.append("usuarioModif=")
				.append(UtilSeguridad.getInstance().getNombre()).append(";");
		buffer.append("documento=");

		for (DocumentoAperturas documentoAperturas : listadoDocs) {
			if (listadoDocs.indexOf(documentoAperturas) > 0) {
				buffer.append("$");
			}
			buffer.append(documentoAperturas.getNombreDoc065());
		}

		buffer.append(";");

		return buffer.toString();
	}

	/**
	 * String.
	 * 
	 * @param apertura
	 *            ComunicacionApertura
	 * @return String
	 */
	public static String concatenarCamposEliminar(ComunicacionApertura apertura) {
		String mascara = Utilities.getInstance().getDateMask();
		SimpleDateFormat sdf = new SimpleDateFormat(mascara);

		StringBuffer buffer = new StringBuffer();
		buffer.append("usuarioModificacion056=")
				.append(apertura.getUsumod056()).append(";");
		buffer.append("fechaModificacion056=")
				.append(apertura.getFecmod056() != null ? sdf.format(apertura
						.getFecmod056()) : "").append(";");
		buffer.append("elementoEliminado056=").append(";");
		buffer.append("motivoEliminacion=")
				.append(apertura.getMotivoBaja() != null ? apertura
						.getMotivoBaja() : "").append(";");
		return buffer.toString();
	}
}
